/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.init;

import com.tiviacz.pizzacraft.blocks.BasinBlock;
import com.tiviacz.pizzacraft.blocks.CheeseBlock;
import com.tiviacz.pizzacraft.blocks.ChoppingBoardBlock;
import com.tiviacz.pizzacraft.blocks.DoughBlock;
import com.tiviacz.pizzacraft.blocks.MortarAndPestleBlock;
import com.tiviacz.pizzacraft.blocks.OliveBookshelfBlock;
import com.tiviacz.pizzacraft.blocks.OliveLeavesBlock;
import com.tiviacz.pizzacraft.blocks.OvenBlock;
import com.tiviacz.pizzacraft.blocks.PizzaBagBlock;
import com.tiviacz.pizzacraft.blocks.PizzaBlock;
import com.tiviacz.pizzacraft.blocks.RawPizzaBlock;
import com.tiviacz.pizzacraft.blocks.crops.DoubleCropBlock;
import com.tiviacz.pizzacraft.blocks.crops.SimpleCropBlock;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.worldgen.trees.OliveTree;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pizzacraft");
    public static final RegistryObject<Block> PIZZA = ModBlocks.registerBlock("pizza", () -> new PizzaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Block> RAW_PIZZA = ModBlocks.registerBlock("raw_pizza", () -> new RawPizzaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Block> DOUGH = ModBlocks.registerBlock("dough", () -> new DoughBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Block> CHEESE_BLOCK = ModBlocks.registerBlock("cheese_block", () -> new CheeseBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76287_, (MaterialColor)MaterialColor.f_76416_).m_60978_(0.5f).m_60918_(SoundType.f_56711_)));
    public static final RegistryObject<Block> MORTAR_AND_PESTLE = ModBlocks.registerBlock("mortar_and_pestle", () -> new MortarAndPestleBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> OVEN = ModBlocks.registerBlock("oven", () -> new OvenBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f).m_60955_().m_60953_(ModBlocks.getLightValueLit(9))));
    public static final RegistryObject<Block> RED_PIZZA_BAG = ModBlocks.registerBlock("red_pizza_bag", () -> new PizzaBagBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_)));
    public static final RegistryObject<Block> GRANITE_BASIN = ModBlocks.registerBlock("granite_basin", () -> new BasinBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76408_).m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> DIORITE_BASIN = ModBlocks.registerBlock("diorite_basin", () -> new BasinBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76412_).m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> ANDESITE_BASIN = ModBlocks.registerBlock("andesite_basin", () -> new BasinBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> BASALT_BASIN = ModBlocks.registerBlock("basalt_basin", () -> new BasinBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(1.25f, 4.2f).m_60918_(SoundType.f_56718_)));
    public static final RegistryObject<Block> BLACKSTONE_BASIN = ModBlocks.registerBlock("blackstone_basin", () -> new BasinBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> OAK_CHOPPING_BOARD = ModBlocks.registerBlock("oak_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> BIRCH_CHOPPING_BOARD = ModBlocks.registerBlock("birch_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)));
    public static final RegistryObject<Block> SPRUCE_CHOPPING_BOARD = ModBlocks.registerBlock("spruce_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final RegistryObject<Block> JUNGLE_CHOPPING_BOARD = ModBlocks.registerBlock("jungle_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)));
    public static final RegistryObject<Block> ACACIA_CHOPPING_BOARD = ModBlocks.registerBlock("acacia_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final RegistryObject<Block> DARK_OAK_CHOPPING_BOARD = ModBlocks.registerBlock("dark_oak_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)));
    public static final RegistryObject<Block> CRIMSON_CHOPPING_BOARD = ModBlocks.registerBlock("crimson_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)));
    public static final RegistryObject<Block> WARPED_CHOPPING_BOARD = ModBlocks.registerBlock("warped_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50656_)));
    public static final RegistryObject<Block> OLIVE_CHOPPING_BOARD = ModBlocks.registerBlock("olive_chopping_board", () -> new ChoppingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> OLIVE_PLANKS = ModBlocks.registerBlock("olive_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> OLIVE_SAPLING = ModBlocks.registerBlock("olive_sapling", () -> new SaplingBlock((AbstractTreeGrower)new OliveTree(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> OLIVE_LOG = ModBlocks.registerOliveLogBlock("olive_log", MaterialColor.f_76411_, MaterialColor.f_76380_);
    public static final RegistryObject<Block> STRIPPED_OLIVE_LOG = ModBlocks.registerOliveLogBlock("stripped_olive_log", MaterialColor.f_76411_, MaterialColor.f_76411_);
    public static final RegistryObject<Block> STRIPPED_OLIVE_WOOD = ModBlocks.registerBlock("stripped_olive_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)));
    public static final RegistryObject<Block> OLIVE_WOOD = ModBlocks.registerBlock("olive_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistryObject<Block> OLIVE_LEAVES = ModBlocks.registerBlock("olive_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    public static final RegistryObject<Block> FRUIT_OLIVE_LEAVES = ModBlocks.registerBlock("fruit_olive_leaves", () -> new OliveLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    public static final RegistryObject<Block> OLIVE_SLAB = ModBlocks.registerBlock("olive_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    public static final RegistryObject<Block> OLIVE_PRESSURE_PLATE = ModBlocks.registerBlock("olive_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_)));
    public static final RegistryObject<Block> OLIVE_FENCE = ModBlocks.registerBlock("olive_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> OLIVE_TRAPDOOR = ModBlocks.registerBlock("olive_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_)));
    public static final RegistryObject<Block> OLIVE_FENCE_GATE = ModBlocks.registerBlock("olive_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_)));
    public static final RegistryObject<Block> OLIVE_BUTTON = ModBlocks.registerBlock("olive_button", () -> new WoodButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_)));
    public static final RegistryObject<Block> OLIVE_STAIRS = ModBlocks.registerBlock("olive_stairs", () -> new StairBlock(() -> ((Block)OLIVE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistryObject<Block> OLIVE_DOOR = ModBlocks.registerBlock("olive_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_)));
    public static final RegistryObject<Block> OLIVE_BOOKSHELF = ModBlocks.registerBlock("olive_bookshelf", () -> new OliveBookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)));
    public static final RegistryObject<Block> BROCCOLI = ModBlocks.registerBlock("broccoli", () -> new SimpleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.BROCCOLI_SEEDS.get()));
    public static final RegistryObject<Block> CORNS = ModBlocks.registerBlock("corns", () -> new DoubleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.CORN.get()));
    public static final RegistryObject<Block> CUCUMBERS = ModBlocks.registerBlock("cucumbers", () -> new SimpleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.CUCUMBER_SEEDS.get()));
    public static final RegistryObject<Block> ONIONS = ModBlocks.registerBlock("onions", () -> new SimpleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.ONION.get()));
    public static final RegistryObject<Block> PEPPERS = ModBlocks.registerBlock("peppers", () -> new SimpleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.PEPPER_SEEDS.get()));
    public static final RegistryObject<Block> PINEAPPLE = ModBlocks.registerBlock("pineapple", () -> new SimpleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.PINEAPPLE_SEEDS.get()));
    public static final RegistryObject<Block> TOMATOES = ModBlocks.registerBlock("tomatoes", () -> new SimpleCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), () -> (Item)ModItems.TOMATO_SEEDS.get()));

    public static Block[] getChoppingBoards() {
        return new Block[]{(Block)OAK_CHOPPING_BOARD.get(), (Block)BIRCH_CHOPPING_BOARD.get(), (Block)SPRUCE_CHOPPING_BOARD.get(), (Block)JUNGLE_CHOPPING_BOARD.get(), (Block)ACACIA_CHOPPING_BOARD.get(), (Block)DARK_OAK_CHOPPING_BOARD.get(), (Block)CRIMSON_CHOPPING_BOARD.get(), (Block)WARPED_CHOPPING_BOARD.get()};
    }

    public static Block[] getBasins() {
        return new Block[]{(Block)GRANITE_BASIN.get(), (Block)DIORITE_BASIN.get(), (Block)ANDESITE_BASIN.get(), (Block)BASALT_BASIN.get(), (Block)BLACKSTONE_BASIN.get()};
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    public static RegistryObject<Block> registerBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    private static RegistryObject<Block> registerOliveLogBlock(String name, MaterialColor topColor, MaterialColor barkColor) {
        return BLOCKS.register(name, () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_)));
    }
}

